<?php 
/*  +------------------------------------------------------------------------+ */
/*  | Artlantis CMS Solutions                                                | */
/*  +------------------------------------------------------------------------+ */
/*  | Lethe Newsletter & Mailing System                                      | */
/*  | Copyright (c) Artlantis Design Studio 2014. All rights reserved.       | */
/*  | Version       2.2                                                      | */
/*  | Last modified 05.11.2018                                               | */
/*  | Email         developer@artlantis.net                                  | */
/*  | Web           http://www.artlantis.net                                 | */
/*  +------------------------------------------------------------------------+ */
error_reporting(E_ALL);
ini_set('display_errors',1);
# Default Timezone for Setup
@date_default_timezone_set('UTC');
# **

require_once('lib/migration.defaults.php');
include_once("lib/functions.php");
include_once("lib/lethe.class.php");
include_once('admin/classes/class.chronos.php');

define('LETHE',dirname(__FILE__));

# Load Defaults
define('LETHE_VERSION','2.2');
define('DEFAULT_LANG','en'); # Lethe Installation Language
include_once("admin/language/sirius_conf.php");
$sirius->langFiles[] = "organizations_back.php";
$sirius->langFiles[] = "settings_back.php";
$sirius->langFiles[] = "settings_back.php";
$sirius->langFiles[] = "subscribers_back.php";
$sirius->loadLanguages(); # Load Globals
define('lethe_sidera_helper',1);
define('SIDERA_HELPER_URL','http://poin.tips/p/artlantis/');
include_once('lib/common.php');

$pos = ((!isset($_GET['pos']) || empty($_GET['pos'])) ? '':trim($_GET['pos']));
$install = ((!isset($_GET['install']) || empty($_GET['install'])) ? false:true);

# XMLHTTP Tests
if($pos=='DBTEST'){

	$getErr = 0;
	if(!isset($_POST['db_host']) || empty($_POST['db_host'])){$getErr++;}else{$db_host = trim($_POST['db_host']);}
	if(!isset($_POST['db_name']) || empty($_POST['db_name'])){$getErr++;}else{$db_name = trim($_POST['db_name']);}
	if(!isset($_POST['db_login']) || empty($_POST['db_login'])){$getErr++;}else{$db_login = trim($_POST['db_login']);}
	if(!isset($_POST['db_pass']) || empty($_POST['db_pass'])){$db_pass='';}else{$db_pass = trim($_POST['db_pass']);}
	
	if($getErr!=0){die('NO');}else{
		
		$myconns = new mysqli($db_host,$db_login,$db_pass,$db_name) or die('NO');
		die('OK');
		
	}
	
}

# Install
if($install){
	echo('<script>$("#myLethe").attr("disabled",false);</script>');
	# Connect to DB
	
	$getErr = 0;
	if(!isset($_POST['db_host']) || empty($_POST['db_host'])){$getErr++;}else{$db_host = trim($_POST['db_host']);}
	if(!isset($_POST['db_name']) || empty($_POST['db_name'])){$getErr++;}else{$db_name = trim($_POST['db_name']);}
	if(!isset($_POST['db_login']) || empty($_POST['db_login'])){$getErr++;}else{$db_login = trim($_POST['db_login']);}
	if(!isset($_POST['db_pass']) || empty($_POST['db_pass'])){$db_pass='';}else{$db_pass = trim($_POST['db_pass']);}
	if(!isset($_POST['db_prefix']) || empty($_POST['db_prefix'])){$db_prefix='lethe_';}else{$db_prefix='lethe_';}
	if($getErr!=0){die('<div class="alert alert-danger">Database Connection Error!</div>');}else{
		$myconn = new mysqli($db_host,$db_login,$db_pass,$db_name) or die('<div class="alert alert-danger">Database Connection Error!</div>');
		require_once ('lib/MysqliDb.php');
		$db = new MysqliDb ($myconn);
		$db->setPrefix($db_prefix);
	}
	
	$errors = '';
	# Prefix Sanitizer
	$db_prefix = preg_replace("/[^A-Za-z]/", '', $db_prefix);
	$db_prefix = strtolower($db_prefix).'_';
	define('db_table_pref',$db_prefix);
	define('set_org_id',1);
	define('LETHE_RESOURCE',LETHE.DIRECTORY_SEPARATOR.'resources'); # Lethe Resource Directory
	include_once('admin/modules/lethe.subscribers/mod.common.php');
	
	# Create Tables (Disable Auto Creation on 2.1 for Strict Table Issues)
	# DB Structure Was Changed for MariaDB


	# System Settings
	if(!isset($_POST['lethe_default_lang']) || empty($_POST['lethe_default_lang'])){$errors.='* Please Choose a Default Language';}
	if(!isset($_POST['lethe_default_timezone']) || empty($_POST['lethe_default_timezone'])){$errors.='* Please Choose a Timezone<br>';}else{
		@date_default_timezone_set(trim($_POST['lethe_default_timezone']));
		$_POST['org_timezone'] = trim($_POST['lethe_default_timezone']);
	}
	if(!isset($_POST['lethe_root_url']) || empty($_POST['lethe_root_url'])){$errors.='* Please Enter Your Lethe URL<br>';}else{
		$_POST['lethe_save_tree_text'] = '<img alt="" src="'. $_POST['lethe_root_url'] .'resources/system/savepaper.png" style="float:left; height:50px; margin:0px 10px; width:50px" /><span style="color:green;font-weight:bold;">Save a Tree!</span><br>Please don’t print this e-mail unless you really need to!';
		define('lethe_root_url',$_POST['lethe_root_url']);
	}
	if(!isset($_POST['lethe_admin_url']) || empty($_POST['lethe_admin_url'])){$errors.='* Please Enter Your Lethe Admin URL<br>';}else{
		define('lethe_admin_url',$_POST['lethe_admin_url']);
	}
	if(!isset($_POST['lethe_theme']) || empty($_POST['lethe_theme'])){$errors.='* Please Choose a Theme<br>';}
	// if(!isset($_POST['lethe_license_key']) || empty($_POST['lethe_license_key'])){
	// 	$errors.='* Please Enter a License Key<br>';
	// }else{
	// 	if(!_iscurl()){
	// 		$errors.='* cURL extension not active on your server!<br>';
	// 	}else{
	// 		$licenseVerify = curl_get_result(base64_decode(SIDERA_FEED_ROOT).'lethe.license.php?key='.urlencode(trim($_POST['lethe_license_key'])));
	// 		if($licenseVerify != 'VALID_LICENSE'){
	// 			$errors.='* Invalid License Key<br>';
	// 		}
	// 	}
	// }
	if(!isset($_POST['lethe_google_recaptcha_public']) || empty($_POST['lethe_google_recaptcha_public'])){$_POST['lethe_google_recaptcha_public']='RECAPTCHA_PUBLIC_KEY';}
	if(!isset($_POST['lethe_google_recaptcha_private']) || empty($_POST['lethe_google_recaptcha_private'])){$_POST['lethe_google_recaptcha_private']='RECAPTCHA_PRIVATE_KEY';}
	$_POST['lethe_debug_mode']='';
	$_POST['lethe_system_notices']='YES';
	$_POST['lethe_sidera_helper']='YES';
	$_POST['lethe_save_tree_on'] = 'YES';
	
	# Submission Account
	if(cntData("SELECT * FROM ". $db_prefix ."submission_accounts WHERE systemAcc=1")==0){
		$_POST['acc_title'] = '# Server 1'; $_POST['daily_limit'] = 500; $_POST['spec_limit_range'] = 1440; $_POST['send_per_conn'] = 50; $_POST['standby_time'] = 1; $_POST['systemAcc'] = "YES"; $_POST['debug'] = ''; $_POST['active'] = 'YES'; $_POST['from_title'] = 'Test Sender'; $_POST['from_mail'] = 'sender@example.com'; $_POST['reply_mail'] = 'reply@example.com'; $_POST['test_mail'] = 'test@example.com'; $_POST['mail_type'] = 0; $_POST['send_method'] = 1; $_POST['mail_engine'] = 'phpmailer'; $_POST['smtp_host'] = 'mail.example.com'; $_POST['smtp_port'] = 587; $_POST['smtp_user'] = 'sender@example.com'; $_POST['smtp_pass'] = 'TestSMTP'; $_POST['smtp_secure'] = 0; $_POST['pop3_host'] = 'mail.example.com'; $_POST['pop3_port'] = 110; $_POST['pop3_user'] = 'sender@example.com'; $_POST['pop3_pass'] = 'TestSMTP'; $_POST['pop3_secure'] = 0; $_POST['imap_host'] = 'mail.example.com'; $_POST['imap_port'] = 143; $_POST['imap_user'] = 'sender@example.com'; $_POST['imap_pass'] = 'TestSMTP'; $_POST['imap_secure'] = 0; $_POST['smtp_auth'] = ''; $_POST['bounce_acc'] = 0; $_POST['dkimactive'] = '';
		$subAcc = new lethe();
		$subAcc->onInstall = true;
		$subAcc->addSubAccount();
	}else{
		$opSubAcc = $myconn->query("SELECT * FROM ". $db_prefix ."submission_accounts WHERE systemAcc=1");
		if(mysqli_num_rows($opSubAcc)==0){
			$errors.='* Submission Account Error<br>';
		}else{
			$opSubAccRs = $opSubAcc->fetch_assoc();
		}
	}
	
	# Organization
	if(!isset($_POST['org_name']) || empty($_POST['org_name'])){$errors.= '* '. organizations_please_enter_a_organization_name .'<br>';}
	if(!isset($_POST['org_sender_title']) || empty($_POST['org_sender_title'])){$errors.= '* '. organizations_please_enter_a_sender_title .'<br>';}
	if(!isset($_POST['org_reply_mail']) || !mailVal($_POST['org_reply_mail'])){$errors.= '* '. organizations_invalid_reply_mail .'<br>';}
	if(!isset($_POST['org_test_mail']) || !mailVal($_POST['org_test_mail'])){$errors.= '* '. organizations_invalid_test_mail .'<br>';}
	//if(!isset($_POST['org_timezone']) || empty($_POST['org_timezone'])){$errors.= '* '. organizations_please_choose_a_timezone .'<br>';}
	if(!isset($_POST['org_after_unsubscribe']) || !is_numeric($_POST['org_after_unsubscribe'])){$errors.= '* '. organizations_please_choose_a_unsubscribe_action .'<br>';}
	if(!isset($_POST['org_verification']) || !is_numeric($_POST['org_verification'])){$errors.= '* '. organizations_please_choose_a_verification_method .'<br>';}
	if(!isset($_POST['org_random_load']) || empty($_POST['org_random_load'])){$_POST['org_random_load']=1;}
	if(!isset($_POST['org_load_type']) || !is_numeric($_POST['org_load_type'])){$errors.= '* '. organizations_please_choose_a_load_type .'<br>';}
	
	# Users
	if(!isset($_POST['usr_name']) || empty($_POST['usr_name'])){
		$errors.='* '. letheglobal_please_enter_a_name .'<br>';
	}
	if(!isset($_POST['usr_mail']) || !mailVal($_POST['usr_mail'])){
		$errors.='* '. letheglobal_invalid_e_mail_address .'<br>';
	}else{
		if(cntData("SELECT ID,mail FROM ". $db_prefix ."users WHERE mail='". mysql_prep($_POST['usr_mail']) ."'")!=0){
			$errors.='* '. letheglobal_e_mail_already_exists .'<br>';
		}
	}
	if(!isset($_POST['usr_pass']) || empty($_POST['usr_pass'])){
		$errors.='* '. letheglobal_please_enter_password .'<br>';
	}else{
		$passLenth = isToo($_POST['usr_pass'],letheglobal_password.' ',5,30);
		if($passLenth!=''){
			$errors.='* '. $passLenth .'<br>';
		}else{
			if(!isset($_POST['usr_pass2']) || ($_POST['usr_pass2']!=$_POST['usr_pass'])){
				$errors.='* '. letheglobal_passwords_mismatch .'<br>';
			}
		}
	}

			
	if($errors==''){
		
		# Update DB File
		$confList = '<?php
# +------------------------------------------------------------------------+
# | Lavalite, The Coder’s CMS Recipe                                                |
# +------------------------------------------------------------------------+
# | Litme Newsletter & Mailing System                                      |
# | Copyright (c) Renfos Technologies 2014. All rights reserved.       |
# | Version       2.2                                                      |
# | Last modified '. date('m.d.Y') .'                                               |
# | Email         india@renfos.com                                  |
# | Web           http://renfos.com/                                 |
# +------------------------------------------------------------------------+';
		$confList .= "
define('db_host','". trim($db_host) ."');
define('db_name','". trim($db_name) ."');
define('db_login','". trim($db_login) ."');
define('db_pass','". trim($db_pass) ."');
define('db_set_name','utf8');
define('db_set_charset','utf8');
define('db_set_collation','utf8_general_ci');
define('db_table_pref','lethe_');
?>";
			$pathw = LETHE.DIRECTORY_SEPARATOR.'lib/lethe.config.php';
			if (!file_exists ($pathw) ) {
				@touch ($pathw);
			}
			$conc=@fopen ($pathw,'w');
			if (!$conc) {
				die(errMod('DB Settings Could Not Be Write','danger'));
			}else{
				if (fputs ($conc,$confList) ){
					
				}else{
					die(errMod('DB Settings Could Not Be Write','danger'));
				}
			}
		
		
		# Update Settings
		$setLethe = new lethe();
		$setLethe->onInstall = true;
		$setLethe->letheSettings();
		
		# Organization
		$orgIDs = 1;
		if(cntData("SELECT ID FROM ". $db_prefix ."organizations")==0){
			$orgLethe = new lethe();
			$orgLethe->onInstall = true;
			$orgLethe->addOrganization();
		}else{
			$opOr = $myconn->query("SELECT ID FROM ". $db_prefix ."organizations");
			$opOrRs = $opOr->fetch_assoc();
			$orgIDs = intval($opOrRs['ID']);
		}
		
		# User
		if(cntData("SELECT ID FROM ". $db_prefix ."users")==0){
			
			$usrLethe = new lethe();
			$usrLethe->onInstall = true;
			$usrLethe->isMaster=1;
			$usrLethe->auth_mode=2;
			$usrLethe->isPrimary=1;
			$usrLethe->OID = $orgIDs;
			$usrLethe->addUser();
		}
		
		# Main Cron
		$letChr = new Crontab();
		$mainCroner = "* * * * * /usr/bin/wget -O - -q '". lethe_root_url ."chronos/lethe.php' >/dev/null 2>&1";
		$letChr->addJob($mainCroner);
		
		die('<script>$("#myLethe").attr("disabled",true);</script>'.errMod('Litme Successfully Installed on Your System!<br>Dont Forget to Remove <strong>install.php</strong> File!<br>Enter your <a href="'.lethe_root_url.'admin/" class="alert-link">Litme Admin Panel</a>','success'));
	}else{
		die('<script>$("#myLethe").attr("disabled",false);</script>'.errMod($errors,'danger'));
	}
}


?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<title>Litme Newsletter &amp; Mailing System Installation</title>

<!-- styles -->
<link rel="stylesheet" href="admin/bootstrap/dist/css/bootstrap.min.css">
<link href="admin/css/ionCheck/ion.checkRadio.css" rel="stylesheet" type="text/css">
<link href="admin/css/ionCheck/ion.checkRadio.cloudy.css" rel="stylesheet" type="text/css">
<link rel="stylesheet" href="admin/css/jquery.switchButton.css">
<link rel="stylesheet" href="admin/css/jquery.fancybox.css">
<link rel="stylesheet" href="admin/css/lethe.css">
<link rel="stylesheet" href="admin/bootstrap/dist/css/lumen_bootstrap.min.css">

<!-- scripts -->
<script src="admin/Scripts/jquery-1.11.1.min.js"></script>

<?php 
if(version_compare(PHP_VERSION, '5.4.0')<0){
	echo('<script>alert("Your PHP Version Does Not Meet System Requirements\nYou cannot continue installation!");</script>');
}
?>
</head>
<body>
<div class="getTheme"></div>
<!-- page content -->
<div id="lethe" class="container">
	<div id="lethe-head">
		<a href="https://lavalite.org/" target="_blank" id="letheLogo"><img src="admin/images/logo.png"></a>
	</div>
	
	<div class="panel panel-default">
	  <div class="panel-body">
		
		<form name="install" id="install" action="javascript:;" method="POST">
		
		<!-- install form start -->
		<div id="carousel" class="carousel slide" data-ride="carousel">
		  <div class="carousel-inner" role="listbox">
			<!-- Welcome -->
			<div class="item active">
				<h3 class="text-primary">Installation</h3><hr>
				<div class="txxs" style="overflow-x:auto; height:300px;">
					<h3>About</h3> <p>Litme PHP Newsletter &amp; Mailing System is a full-featured newsletter PHP based script which fulfils all subscribers, emails, marketing and newsletter related needs for both personal and business environments.</p> <p>It has robust, efficient and unique features! This is an all-in-one newsletter tool for your site can be configured to behave as desired and it will provide the best experience for your email subscribers at the same time.</p> <p>Litme works the way you do so you can focus on creating newsletters and giving your website the necessary exposure!</p> <p>Please follow steps for Litme installation.</p> <h3>Support and Customization</h3> <p>If you have trouble with installation your can contact with our support team. <a href="mailto:india@renfos.com">india@renfos.com</a></p> <p>Litme was developed by Renfos Technologies, if you want to modify that script you can contact with developer partnership. <a href="mailto:support@lavalite.com">support@lavalite.com</a></p> <h3>License Summary</h3> <ul> <li>Non-commercial use only</li> <li>Cannot modify source-code for any purpose (cannot create derivative works)</li> <li>Support provided as follows :<br />- Responding to questions or problems regarding the item and its features<br />- Fixing bugs and reported issues<br />- Providing updates to ensure compatibility with new software versions<br /><span style="text-decoration: underline;">* Item support does not include:</span> <br />- Customization and installation services <br />- Support for third party software and plug-ins</li> </ul> 
				</div>
				
				<div class="carousel-cont"><hr>
					<span class="pull-right">
						<button data-target="#carousel" data-slide="next" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
							<span class="sr-only">Next</span>
						</button>
					</span>
				</div>
			</div>
			<!-- Requirements -->
			<div class="item">
				<h3 class="text-primary">Requirements<span class="text-muted pull-right">STEP 1</span></h3><hr>

				<div class="row"><div class="col-md-5">
				<table class="table table-striped" width="500">
					<thead>
						<tr>
							<th>&nbsp;</th>
							<th>Required</th>
							<th>System</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><?php echo(sh('pX6gY1bgOl'));?>PHP Version</td>
							<td>5.4+</td>
							<td>
								<?php echo(getBullets(((version_compare(PHP_VERSION, '5.4.0') >=0) ? 1:0)));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('GAYM2EWrXQ'));?>MySQLi Extension</td>
							<td>Yes</td>
							<td>
								<?php echo(getBullets( ((extension_loaded ('mysqli')) ? 1:0) ));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('maz8jKQgpO'));?>Script Timeout</td>
							<td>allowed to change</td>
							<td>
								<?php 
								$currTimeLimit = @set_time_limit(300);
								$changedTimeLimit = ini_get('max_execution_time');
								echo(getBullets( (($changedTimeLimit==300) ? 1:0) ));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('6mxg6vwg4n'));?>Curl Extension</td>
							<td>Yes</td>
							<td>
								<?php echo(getBullets( (( _iscurl() ) ? 1:0) ));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('KX1M7KaMmV'));?>fopen Extension</td>
							<td>Yes</td>
							<td>
								<?php echo(getBullets( (( function_exists('fopen') ) ? 1:0) ));?>
							</td>
						</tr>
						<tr>
							<td>mb_substr() Function</td>
							<td>Yes</td>
							<td>
								<?php echo(getBullets( (( function_exists('mb_substr') ) ? 1:0) ));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('ZVKMZN1MLA'));?>Shell Access</td>
							<td>Yes</td>
							<td>
								<?php echo(getBullets( (( shell_exec('crontab -l') ) ? 1:0) ));
								//echo(getBullets(1));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('2WzrLvZ8m4'));?>Writable Folders</td>
							<td>Yes</td>
							<td>
								<?php 
									$writableList = array(
															LETHE.DIRECTORY_SEPARATOR.'resources',
															LETHE.DIRECTORY_SEPARATOR.'/lib/lethe.config.php',
															LETHE.DIRECTORY_SEPARATOR.'/lib/lethe.sets.php'
														  );
									$isWritable = 0;
									foreach($writableList as $k=>$v){
										if(is_writable($v)){
											$isWritable++;
										}
									}
									echo(getBullets( (( $isWritable==count($writableList) ) ? 1:0) ));
								?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('PzWM4Kerqx'));?>IMAP Open</td>
							<td>Yes</td>
							<td>
								<?php echo(getBullets( (( function_exists('imap_open') ) ? 1:0) ));?>
							</td>
						</tr>
					</tbody>
				</table>
				</div>
<div class="col-md-5">
				<table class="table table-striped" width="500">
					<thead>
						<tr>
							<th>&nbsp;</th>
							<th>Recommended</th>
							<th>System</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><?php echo(sh('o9Kg04EgVx'));?>Script Execute Time</td>
							<td>Unlimited</td>
							<td>
								<?php echo(ini_get('max_execution_time'));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('2AwgKjo8WD'));?>Upload Limit</td>
							<td>40M</td>
							<td>
								<?php echo(ini_get('upload_max_filesize'));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('maz8jKQgpO'));?>Post Max Size</td>
							<td>40M</td>
							<td>
								<?php echo(ini_get('post_max_size'));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('maz8jKQgpO'));?>PHP Mail() function</td>
							<td>if you get errors from SMTP</td>
							<td>
								<?php echo(getBullets(((function_exists('mail')) ? 1:0)));?>
							</td>
						</tr>
						<tr>
							<td><?php echo(sh('m0k8vk9gJw'));?>fgetcsv() function</td>
							<td>for Advanced CSV Imports</td>
							<td>
								<?php echo(getBullets(((function_exists('fgetcsv')) ? 1:0)));?>
							</td>
						</tr>
					</tbody>
				</table>
				<span class="help-block">Above settings is not required, Litme will work as your system settings. But if you want to import large amount datas, your system may block your actions and its will not work properly.</span>
				</div>
				</div>
				
				<div class="carousel-cont"><hr>
					<span class="pull-right">
						<button data-target="#carousel" data-slide="prev" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
							<span class="sr-only">Previous</span>
						</button>
						<button data-target="#carousel" data-slide="next" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
							<span class="sr-only">Next</span>
						</button>
					</span>
				</div>
			</div>
			<!-- Database -->
			<div class="item">
				<h3 class="text-primary">Database Settings<span class="text-muted pull-right">STEP 2</span></h3><hr>
				
				<div class="row">
					<div class="col-md-4">
						<div class="alert alert-danger">
							<strong>IMPORTANT:</strong> Auto table creation disabled on v2.1, please import table structure via phpMyAdmin before installation. Some hosting service sql_mode configurations does not allow to create tables as our script-based queries.<br><br>
							Please check your Litme root, you will see a <strong>.sql</strong> file.
						</div>
						<div class="form-group">
							<label for="db_host">Database Host</label>
							<input type="text" name="db_host" id="db_host" class="form-control">
						</div>
						<div class="form-group">
							<label for="db_name">Database Name</label>
							<input type="text" name="db_name" id="db_name" class="form-control">
						</div>
						<div class="form-group">
							<label for="db_login">Database Login</label>
							<input type="text" name="db_login" id="db_login" class="form-control">
						</div>
						<div class="form-group">
							<label for="db_pass">Database Password</label>
							<div class="input-group">
								<input type="password" name="db_pass" id="db_pass" class="form-control">
								<span class="input-group-btn">
									<button class="btn btn-default" onclick="passShows('db_pass');" type="button"><span class="glyphicon glyphicon-eye-close"></button>
								</span>
							</div>
						</div>
<!--
						<div class="form-group">
							<label for="db_prefix"><?php echo(sh('1vngRN3gmk'));?>Table Prefix</label>
							<input type="text" name="db_prefix" id="db_prefix" class="form-control" placeholder="lethe_">
						</div>
-->
						<div class="form-group">
							<button type="button" class="btn btn-warning" id="dbTester"><span class="dbRes"><span class="glyphicon glyphicon-link"></span></span> Test Connection</button>
						</div>
					</div>
					<script>
						$(document).ready(function(){
							$("#dbTester").click(function(){
								var dbtestBut = $(this);
								$(".dbRes").html('<span class="spin glyphicon glyphicon-refresh"></span>');
								dbtestBut.attr('disabled',true);
								$.ajax({
									url : "install.php?pos=DBTEST",
									type: "POST",
									data : $("#install").serialize(),
									contentType: "application/x-www-form-urlencoded",
									success: function(data, textStatus, jqXHR)
									{
										if(data=='OK'){
											dbtestBut.removeClass('btn-danger btn-warning');
											dbtestBut.addClass('btn-success');
											$(".dbRes").html('<span class="glyphicon glyphicon-ok"></span>');
										}else{
											dbtestBut.removeClass('btn-success btn-warning');
											dbtestBut.addClass('btn-danger');
											$(".dbRes").html('<span class="glyphicon glyphicon-remove"></span>');
										}
										dbtestBut.attr('disabled',false);
									},
									error: function (jqXHR, textStatus, errorThrown)
									{
										dbtestBut.removeClass('btn-success btn-warning');
										dbtestBut.addClass('btn-danger');
										$(".dbRes").html('<span class="glyphicon glyphicon-remove"></span>');
										dbtestBut.attr('disabled',false);
									}
								});
							});
						});
					</script>
				</div>
				
				<div class="carousel-cont"><hr>
					<span class="pull-right">
						<button data-target="#carousel" data-slide="prev" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
							<span class="sr-only">Previous</span>
						</button>
						<button data-target="#carousel" data-slide="next" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
							<span class="sr-only">Next</span>
						</button>
					</span>
				</div>
			</div>
			<!-- System Settings -->
			<div class="item">
				<h3 class="text-primary">System Settings<span class="text-muted pull-right">STEP 3</span></h3><hr>
				
				<div class="row">
					<div class="col-md-4">
						<div class="form-group">
							<label for="lethe_default_lang"><?php echo(settings_default_language);?></label>
							<select name="lethe_default_lang" id="lethe_default_lang" class="form-control autoWidth">
								<?php foreach($SLNG_LIST as $k=>$v){
									echo('<option value="'. $k .'">'. showIn($v['sname'],'page') .'</option>');
								}?>
							</select>
						</div>
						<div class="form-group">
							<label for="lethe_default_timezone"><?php echo(settings_default_timezone);?></label>
							<select name="lethe_default_timezone" id="lethe_default_timezone" class="form-control autoWidth">
								<?php 
								$tzones = timezone_list();
								foreach($tzones as $k=>$v){echo('<option value="'. $k .'"'. ((isseter('org_timezone')) ? formSelector($_POST['org_timezone'],$k,0):'') .'>'. $v .'</option>');}?>
							</select>
						</div>
						<div class="form-group">
							<label for="lethe_theme"><?php echo(settings_default_theme);?></label>
							<select name="lethe_theme" id="lethe_theme" class="form-control autoWidth">
								<?php 
								foreach($LETHE_THEME_LIST as $k=>$v){echo('<option value="'. $k .'"'. ((isseter('lethe_theme')) ? formSelector($_POST['lethe_theme'],$k,0):'') .'>'. $v .'</option>');}?>
							</select>
						</div>
						<div class="form-group">
							<label for="lethe_root_url">Litme URL</label>
							<input type="url" value="<?php echo(relDocs(LETHE));?>/" name="lethe_root_url" id="lethe_root_url" class="form-control" placeholder="http://www.example.com/litme/">
							<span class="help-block"><small>Change if its incorrect. e.g. http://www.example.com/litme/</small></span>
						</div>
						<div class="form-group">
							<label for="lethe_admin_url">Litme Admin URL</label>
							<input type="url" name="lethe_admin_url" id="lethe_admin_url" value="<?php echo(relDocs(LETHE));?>/admin/" class="form-control" placeholder="http://www.example.com/litme/admin/">
							<span class="help-block"><small>Change if its incorrect. e.g. http://www.example.com/litme/admin/</small></span>
						</div>
						<div class="form-group">
							<label for="lethe_save_tree_on"><?php echo(settings_save_tree_on);?></label>
							<div>
							<input type="checkbox" name="lethe_save_tree_on" id="lethe_save_tree_on" data-on-label="<?php echo(letheglobal_yes);?>" data-off-label="<?php echo(letheglobal_no);?>" value="YES" class="letheSwitch"<?php echo(((isset($_POST['lethe_save_tree_on']) && $_POST['lethe_save_tree_on']=='YES') ? ' checked':''));?>>
							</div>
						</div>
						<div class="form-group">
							<label for="lethe_google_recaptcha_public"><?php echo('Google reCaptcha Public Key');?></label>
							<div class="input-group">
								<input type="password" name="lethe_google_recaptcha_public" id="lethe_google_recaptcha_public" value="<?php echo(((isseter('lethe_google_recaptcha_public')) ? showIn($_POST['lethe_google_recaptcha_public'],'input'):''));?>" class="form-control autoWidth" size="50">
								<span class="input-group-btn">
									<button class="btn btn-default" onclick="passShows('lethe_google_recaptcha_public');" type="button"><span class="glyphicon glyphicon-eye-close"></button>
								</span>
							</div>
						</div>
						<div class="form-group">
							<label for="lethe_google_recaptcha_private"><?php echo('Google reCaptcha Private Key');?></label>
							<div class="input-group">
								<input type="password" name="lethe_google_recaptcha_private" id="lethe_google_recaptcha_private" value="<?php echo(((isseter('lethe_google_recaptcha_private')) ? showIn($_POST['lethe_google_recaptcha_private'],'input'):''));?>" class="form-control autoWidth" size="50">
								<span class="input-group-btn">
									<button class="btn btn-default" onclick="passShows('lethe_google_recaptcha_private');" type="button"><span class="glyphicon glyphicon-eye-close"></button>
								</span>
							</div>
						</div>
						<!-- <div class="form-group">
							<label for="lethe_license_key"></label>
							<div class="input-group">
								<input type="password" name="lethe_license_key" id="lethe_license_key" class="form-control autoWidth" size="50">
								<span class="input-group-btn">
									<button class="btn btn-default"  type="button"><span class="glyphicon glyphicon-eye-close"></button>
								</span>
							</div>
						</div> -->
					</div>
				</div>
				
				<div class="carousel-cont"><hr>
					<span class="pull-right">
						<button data-target="#carousel" data-slide="prev" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
							<span class="sr-only">Previous</span>
						</button>
						<button data-target="#carousel" data-slide="next" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
							<span class="sr-only">Next</span>
						</button>
					</span>
				</div>
			</div>
			<!-- Submission -->
			<div class="item">
			  <h3 class="text-primary">Submission Account<span class="text-muted pull-right">STEP 4</span></h3><hr>
			  
			  <div class="alert alert-info">
				Submission Account will create automatically with default settings as mail() function.<br>
				But, some hosting service providers doesn't allow to use mail() function for shared servers.<br>
				You must set it with correct informations after logged in.
			  </div>
			  
				<div class="carousel-cont"><hr>
					<span class="pull-right">
						<button data-target="#carousel" data-slide="prev" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
							<span class="sr-only">Previous</span>
						</button>
						<button data-target="#carousel" data-slide="next" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
							<span class="sr-only">Next</span>
						</button>
					</span>
				</div>
			</div>
			<!-- Organization -->
			<div class="item">
			  <h3 class="text-primary">Organization<span class="text-muted pull-right">STEP 5</span></h3><hr>
			  
				<div role="tabpanel">

				  <!-- Nav tabs -->
				  <ul class="nav nav-tabs" role="tablist">
					<li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab"><?php echo(organizations_general);?></a></li>
					<li role="presentation"><a href="#settings" aria-controls="settings" role="tab" data-toggle="tab"><?php echo(organizations_settings);?></a></li>
				  </ul>

				  <!-- Tab panes -->
				  <div class="tab-content">
					<!-- GENERAL -->
					<div role="tabpanel" class="tab-pane fade in active" id="general">
						&nbsp;
						<div class="form-group">
							<label for="org_name"><?php echo(organizations_organization_name);?></label>
							<input type="text" class="form-control autoWidth" id="org_name" name="org_name" size="40" value="<?php echo((isseter('org_name')) ? showIn($_POST['org_name'],'input'):'');?>">
						</div>
					
					</div>
					<!-- LIMITS -->
					<input type="hidden" name="org_max_disk_quota" value="0">
					<input type="hidden" name="org_max_user" value="0">
					<input type="hidden" name="org_max_newsletter" value="0">
					<input type="hidden" name="org_max_autoresponder" value="0">
					<input type="hidden" name="org_max_subscriber" value="0">
					<input type="hidden" name="org_max_subscriber_group" value="0">
					<input type="hidden" name="org_max_subscribe_form" value="0">
					<input type="hidden" name="org_max_blacklist" value="0">
					<input type="hidden" name="org_max_template" value="0">
					<input type="hidden" name="org_max_shortcode" value="0">
					<input type="hidden" name="org_max_daily_limit" value="0">
					<input type="hidden" name="org_standby_organization" value="0">

					<!-- SETTINGS -->
					<div role="tabpanel" class="tab-pane fade" id="settings">
						&nbsp;
						<input type="hidden" name="org_submission_account" value="1">
						
						<div class="form-group">
							<label for="org_sender_title"><?php echo(organizations_sender_title);?></label>
							<input type="text" class="form-control autoWidth" id="org_sender_title" name="org_sender_title" value="<?php echo((isseter('org_sender_title')) ? showIn($_POST['org_sender_title'],'input'):'');?>">
						</div>
						
						<div class="form-group">
							<label for="org_reply_mail"><?php echo(organizations_reply_e_mail);?></label>
							<input type="email" class="form-control autoWidth" id="org_reply_mail" name="org_reply_mail" value="<?php echo((isseter('org_reply_mail')) ? showIn($_POST['org_reply_mail'],'input'):'');?>">
						</div>
						
						<div class="form-group">
							<label for="org_test_mail"><?php echo(organizations_test_e_mail);?></label>
							<input type="email" class="form-control autoWidth" id="org_test_mail" name="org_test_mail" value="<?php echo((isseter('org_test_mail')) ? showIn($_POST['org_test_mail'],'input'):'');?>">
						</div>
						
						<div class="form-group sHide">
							<label for="org_timezone"><?php echo(organizations_timezone);?></label>
							<select name="org_timezone" id="org_timezone" class="form-control autoWidth">
								<?php 
								$tzones = timezone_list();
								foreach($tzones as $k=>$v){echo('<option value="'. $k .'"'. ((isseter('org_timezone')) ? formSelector($_POST['org_timezone'],$k,0):'') .'>'. $v .'</option>');}?>
							</select>
						</div>
						
						<div class="form-group">
							<label for="org_after_unsubscribe"><?php echo(organizations_after_unsubscribe);?></label>
							<select name="org_after_unsubscribe" id="org_after_unsubscribe" class="form-control autoWidth">
								<?php 
								foreach($LETHE_AFTER_UNSUBSCRIBE as $k=>$v){
									echo('<option value="'. $k .'"'. ((isseter('org_after_unsubscribe',0,1)) ? formSelector($_POST['org_after_unsubscribe'],$k,0):'') .'>'. $v .'</option>');
								}
								?>
							</select>
						</div>
						
						<div class="form-group">
							<label for="org_verification"><?php echo(organizations_verification);?></label>
							<select name="org_verification" id="org_verification" class="form-control autoWidth">
								<?php 
								foreach($LETHE_VERIFICATION_TYPE as $k=>$v){
									echo('<option value="'. $k .'"'. ((isseter('org_verification',0,1)) ? formSelector($_POST['org_verification'],$k,0):'') .'>'. $v .'</option>');
								}
								?>
							</select>
						</div>
						
						<div class="form-group sHide">
							<label for="org_random_load"><?php echo(organizations_random_loader);?></label>
							<div>
							<input type="checkbox" name="org_random_load" id="org_random_load" data-on-label="<?php echo(letheglobal_yes);?>" data-off-label="<?php echo(letheglobal_no);?>" value="YES" class="letheSwitch"<?php echo(((isset($_POST['org_random_load']) && $_POST['org_random_load']=='YES') ? ' checked':''));?>>
							</div>
						</div>
						
						<div class="form-group">
							<label for="org_load_type"><?php echo(organizations_load);?></label>
							<select name="org_load_type" id="org_load_type" class="form-control autoWidth">
								<?php 
								foreach($LETHE_LOAD_TYPES as $k=>$v){
									echo('<option value="'. $k .'"'. ((isseter('org_load_type',0,1)) ? formSelector($_POST['org_load_type'],$k,0):'') .'>'. $v .'</option>');
								}
								?>
							</select>
						</div>
					
					</div>
				  </div>

				</div>
			  
				<div class="carousel-cont"><hr>
					<span class="pull-right">
						<button data-target="#carousel" data-slide="prev" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
							<span class="sr-only">Previous</span>
						</button>
						<button data-target="#carousel" data-slide="next" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
							<span class="sr-only">Next</span>
						</button>
					</span>
				</div>
			</div>
			<!-- User -->
			<div class="item">
			  <h3 class="text-primary">Administration<span class="text-muted pull-right">STEP 6</span></h3><hr>
			  
				<div class="form-group">
					<label for="usr_name"><?php echo(letheglobal_name);?></label>
					<input type="text" name="usr_name" id="usr_name" value="<?php echo(((isset($_POST['usr_name'])) ? showIn($_POST['usr_name'],'input'):''))?>" class="form-control autoWidth">
				</div>
				<div class="form-group">
					<label for="usr_mail"><?php echo(letheglobal_e_mail);?></label>
					<input type="email" name="usr_mail" id="usr_mail" value="<?php echo(((isset($_POST['usr_mail'])) ? showIn($_POST['usr_mail'],'input'):''))?>" class="form-control autoWidth">
				</div>
				<div class="form-group">
					<label for="usr_pass"><?php echo(letheglobal_password);?></label>
					<input type="password" name="usr_pass" id="usr_pass" value="" class="form-control autoWidth" autocomplete="off">
				</div>
				<div class="form-group">
					<label for="usr_pass2"><?php echo(letheglobal_type_it_again);?></label>
					<input type="password" name="usr_pass2" id="usr_pass2" value="" class="form-control autoWidth" autocomplete="off">
				</div>
			  
				<div class="carousel-cont"><hr>
					<span class="pull-right">
						<button data-target="#carousel" data-slide="prev" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
							<span class="sr-only">Previous</span>
						</button>
						<button data-target="#carousel" data-slide="next" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
							<span class="sr-only">Next</span>
						</button>
					</span>
				</div>
			</div>
			
			<!-- Complete -->
			<div class="item">
			  <h3 class="text-primary">Complete<span class="text-muted pull-right">STEP 7</span></h3><hr>
			  
			   <div id="installResult">
			   
			   </div>
			  
				<div class="form-group">
					<button type="submit" name="myLethe" id="myLethe" class="btn btn-success">Install Now!</button>
				</div>
			  
				<div class="carousel-cont"><hr>
					<span class="pull-right">
						<button data-target="#carousel" data-slide="prev" type="button" class="btn btn-success">
							<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
							<span class="sr-only">Previous</span>
						</button>
					</span>
				</div>
			</div>
			
		  </div>
		</div>
		<!-- install form end -->		
		
		</form>
		
	  </div>
	</div>
	
	<div class="lethe-footer">
		<p class="text-muted">
			<small>
			<a href="https://lavalite.org/" target="_blank">Litme Newsletter &amp; Mailing System</a> v.<?php echo(LETHE_VERSION);?> &copy; 2015-<?php echo(date('Y'));?>.<br>
			Powered by <a href="http://renfos.com/" target="_blank">Renfos Technologies</a>
			</small>
		</p>
	</div>
</div>

<!-- body end -->
<script type="text/javascript">
	/* Pointips */
	var sidera_helper_uri = "//poin.tips/p/artlantis/";
	
	function passShows(f){
		var fpos = $("#"+f).attr('type');
		if(fpos=='text'){
			$("#"+f).attr('type','password');
		}else{
			$("#"+f).attr('type','text');
		}
	}
	
	$(document).ready(function(){
		/* Layout */
		$('.carousel').carousel({
			interval: false
		});
		/* Change Theme */
		$("#lethe_theme").on('change',function(){
			var selTheme = $(this).val();
			  $(".getTheme").html('<link type="text/css" rel="stylesheet" href="admin/bootstrap/dist/css/'+ selTheme +'_bootstrap.min.css"></link>');
		});
		
		/* Install */
		$("#myLethe").click(function(e){
			e.preventDefault();
			$("#myLethe").attr('disabled','true');
			$("#installResult").html('<span class="spin glyphicon glyphicon-reload"></span> Please wait..');
			$.ajax({
				url : "install.php?install=true",
				type: "POST",
				data : $("#install").serialize(),
				contentType: "application/x-www-form-urlencoded",
				success: function(data, textStatus, jqXHR)
				{
					$("#installResult").html(data);
				},
				error: function (jqXHR, textStatus, errorThrown)
				{
					$("#myLethe").attr('disabled','false');
					$("#installResult").html('<div class="alert alert-danger">There an error occurred while sending form!</div>');
				}
			});
			
		});
	});
</script>
<script src="admin/Scripts/jquery-ui.min.js"></script>
<script src="admin/bootstrap/dist/js/bootstrap.min.js"></script>
<script src="admin/Scripts/ion.checkRadio.min.js"></script>
<script src="admin/Scripts/jquery.switchButton.js"></script>
<script src="admin/Scripts/jquery.fancybox.pack.js"></script>
<script src="admin/Scripts/lethe.js"></script>
</body>
</html>